function allvars=AAmakefeatures(row,column)

n=length(row); %number of games

%% Create intermediate variables

Nash=cell(n,1);
surviveround1=cell(n,1);
surviveround2=cell(n,1);
surviveround3=cell(n,1);
level1=cell(n,1);
maxpayoffs=cell(n,1);
level2=cell(n,1);
ParetoAct=cell(n,1);
ParetoUndAct=cell(n,1);
Maxmin=cell(n,1);
level3=cell(n,1);
level4=cell(n,1);
level5=cell(n,1);
level6=cell(n,1);
level7=cell(n,1);
maxmax=cell(n,1);
minmin=cell(n,1);
for i=1:n
    Nash{i}=NE(row{i},column{i});
    surviveround1{i}=elim(row{i},column{i}); 
    surviveround2{i}=elim(surviveround1{i}{1}{2},surviveround1{i}{2}{2});
    surviveround2{i}{1}{1}=surviveround1{i}{1}{1}(surviveround2{i}{1}{1});
    surviveround2{i}{2}{1}=surviveround1{i}{2}{1}(surviveround2{i}{2}{1});
    surviveround3{i}=elim(surviveround2{i}{1}{2},surviveround2{i}{2}{2});
    surviveround3{i}{1}{1}=surviveround2{i}{1}{1}(surviveround3{i}{1}{1});
    surviveround3{i}{2}{1}=surviveround2{i}{2}{1}(surviveround3{i}{2}{1});
    maxpayoffs{i}=maxsum(row{i},column{i});
    level1{i}=BRuniform(row{i},column{i});
    level2{i}=BRlevelzero(level1{i},row{i},column{i});
    ParetoAct{i}=ParetoAction(row{i},column{i});
    ParetoUndAct{i}=ParetoUndAction(row{i},column{i});
    Maxmin{i}=MaxMin(row{i},column{i});
    level3{i}=levelup(level2{i},row{i},column{i});
    level4{i}=levelup(level3{i},row{i},column{i});
    level5{i}=levelup(level4{i},row{i},column{i});
    level6{i}=levelup(level5{i},row{i},column{i});
    level7{i}=levelup(level6{i},row{i},column{i});
    maxmax{i}=MaxMax(row{i});
    minmin{i}=MinMin(row{i});
end


%% Features Describing Actions

IndMaxPayoff=cell(n,1);
IndParetoAct=cell(n,1);
IndParetoUndAct=cell(n,1);
for i=1:n
    IndMaxPayoff{i}=max(maxpayoffs{i},[],2);
    IndParetoAct{i}=max(ParetoAct{i},[],2);
    IndParetoUndAct{i}=max(ParetoUndAct{i},[],2);
end

GoodandParetoUnd5=cell(1,n);
GoodandParetoUnd6=cell(1,n);
GoodandParetoUnd7=cell(1,n);
GoodandParetoUnd8=cell(1,n);
for i=1:n
    GoodandParetoUnd5{i}=zeros(3,1);
    GoodandParetoUnd6{i}=zeros(3,1);
    GoodandParetoUnd7{i}=zeros(3,1);
    GoodandParetoUnd8{i}=zeros(3,1);
    R=row{i};
    for j=1:3
        for k=1:3
            if ParetoUndAct{i}(j,k)==1
                rowpay=R(j,k);
                if rowpay>0.5*max(max(R))
                    GoodandParetoUnd5{i}(j)=1;
                end
                if rowpay>0.6*max(max(R))
                    GoodandParetoUnd6{i}(j)=1;
                end
                if rowpay>0.7*max(max(R))
                    GoodandParetoUnd7{i}(j)=1;
                end
                if rowpay>0.8*max(max(R))
                    GoodandParetoUnd8{i}(j)=1;
                end
            end
        end
    end
end


%% Level k Support Set

level1ans=cell(n,1); %Indicator for whether the action is level 1
for i=1:n
    level1ans{i}=zeros(3,1);
    for j=1:3
        if 1-isempty(strmatch(j,level1{i}{1}))==1
            level1ans{i}(j)=1;
        end
    end
end

supportlevk=zeros(n,3); %Actions that are level k for some k
for i=1:n
    [~,maxind]=max(sum(row{i},2));
    w=length(maxind);
    for j=1:w
        h=maxind(j);
        supportlevk(i,h)=1;
    end
    h=find(level2{i}(1,:));
    supportlevk(i,h)=1;
    h=find(level3{i}(1,:));
    supportlevk(i,h)=1;
    h=find(level4{i}(1,:));
    supportlevk(i,h)=1;
    h=find(level5{i}(1,:));
    supportlevk(i,h)=1;
    h=find(level6{i}(1,:));
    supportlevk(i,h)=1;
    h=find(level7{i}(1,:));
    supportlevk(i,h)=1;
end


%% Decoys 

maxinsupp=zeros(n,1); %Highest possible payoff from a level k action
maxoutsupp=zeros(n,1); %Highest possible payoff from an action that is not level k for any k
for i=1:n
    if length(find(supportlevk(i,:)))<3
        payoffsum=row{i}+column{i};
        maxpayoff=max(payoffsum);
        maxinsupp(i)=max(maxpayoff(find(supportlevk(i,:))));
        maxoutsupp(i)=max(maxpayoff(find(supportlevk(i,:)==0)));
    else
        payoffsum=row{i}+column{i};
        maxpayoff=max(payoffsum);
        maxinsupp(i)=max(maxpayoff(find(supportlevk(i,:))));
        maxoutsupp(i)=0;
    end
end

decoy1=zeros(n,1); % Is there a non-level k that yields much higher total payoffs than any level k action?
decoy2=zeros(n,1); 
decoy3=zeros(n,1); 
for i=1:n
    maxpay=max(max(row{i}));
    if maxinsupp(i)<maxoutsupp(i)-0.2*maxpay
        decoy1(i)=1;
    end
    if maxinsupp(i)<maxoutsupp(i)-0.4*maxpay
        decoy2(i)=1;
    end
    if maxinsupp(i)<maxoutsupp(i)-0.6*maxpay
        decoy3(i)=1;
    end
end

%% Features describing NE

IndNE=cell(n,1);
NashSet=cell(n,1);
ParetoNE=cell(n,1);
IndParetoNE=cell(n,1);
for i=1:n
    IndNE{i}=max(Nash{i},[],2);
    ParetoNE{i}=zeros(3,3);
    if isequal(Nash{i},zeros(3,3))==0 %if there are any NE...
        R=reshape(row{i},9,1);
        C=reshape(column{i},9,1);
        NashSet{i}=[R(find(Nash{i}==1)) C(find(Nash{i}==1))];
        ParetoNE{i}=ParetoNash(Nash{i},NashSet{i},row{i},column{i});
    end
    IndParetoNE{i}=max(ParetoNE{i},[],2);
end

symmNE=cell(1,n); %is there a symmmetric NE
for i=1:n
    symmNE{i}=SymmNE(row{i},column{i});
end

goodNE=cell(1,n);
goodNE70=cell(1,n);
goodNE80=cell(1,n);
for i=1:n
    goodNE{i}=zeros(3,3);
    goodNE70{i}=zeros(3,3);
    goodNE80{i}=zeros(3,3);
    largesttotal=max(max(row{i}+column{i})); %max-max in payoff matrix
    [x,y]=find(Nash{i}); %all NE
    m=length(x); %number of NE
    for j=1:m
        payoffR(j)=row{i}(x(j),y(j)); %row player payoff in NE indexed by j
        payoffC(j)=column{i}(x(j),y(j));
        payoffRC(j)=payoffR(j)+payoffC(j);
        if double(logical(payoffRC(j)>0.75*largesttotal))==1 %NE achieves 0.75 of total possible sum of payoffs
            goodNE{i}(x(j),y(j))=1;
        end
        if double(logical(payoffRC(j)>0.70*largesttotal))==1 %NE achieves 0.75 of total possible sum of payoffs
            goodNE70{i}(x(j),y(j))=1;
        end
        if double(logical(payoffRC(j)>0.80*largesttotal))==1 %NE achieves 0.80 of total possible sum of payoffs
            goodNE80{i}(x(j),y(j))=1;
        end
        clear payoffR payoffC payoffRC
    end
end

PartofGoodNE=cell(3,1);
PartofGoodNELev1=cell(3,1);
PartofGoodNENotLev1=cell(3,1);
PartofGoodNENotLevk=cell(3,1);
PartofGoodSymmNE=cell(3,1);
PartofGoodSymmNELev1=cell(3,1);
PartofGoodSymmNENotLev1=cell(3,1);
PartofGoodSymmNENotLevk=cell(3,1);
for i=1:n %game
    for j=1:3 %action
        PartofGoodNE{i}(j)=logical(sum(goodNE{i}(j,:))>0);
        PartofGoodNELev1{i}(j)=logical(sum(goodNE{i}(j,:))>0)*level1ans{i}(j);
        PartofGoodNENotLev1{i}(j)=logical(sum(goodNE{i}(j,:))>0)*abs(1-level1ans{i}(j));
        PartofGoodNENotLevk{i}(j)=logical(sum(goodNE{i}(j,:))>0)*supportlevk(i,j);        
        PartofGoodSymmNE{i}(j)=logical(sum(goodNE{i}(j,:))>0)*symmNE{i}(j);
        PartofGoodSymmNELev1{i}(j)=logical(sum(goodNE{i}(j,:))>0)*symmNE{i}(j)*level1ans{i}(j);
        PartofGoodSymmNENotLev1{i}(j)=logical(sum(goodNE{i}(j,:))>0)*symmNE{i}(j)*abs(1-level1ans{i}(j));
        PartofGoodSymmNENotLevk{i}(j)=logical(sum(goodNE{i}(j,:))>0)*symmNE{i}(j)*supportlevk(i,j);
    end
end

PartofGoodSymmNENotLev1_70=cell(3,1);
PartofGoodSymmNENotLev1_80=cell(3,1);
for i=1:n %game
    for j=1:3 %action
        PartofGoodSymmNENotLev1_70{i}(j)=logical(sum(goodNE70{i}(j,:))>0)*symmNE{i}(j)*abs(1-level1ans{i}(j));
        PartofGoodSymmNENotLev1_80{i}(j)=logical(sum(goodNE80{i}(j,:))>0)*symmNE{i}(j)*abs(1-level1ans{i}(j));
    end
end

verygoodNE=zeros(1,n);
verygoodNElev1=zeros(1,n);
verygoodNEnotlev1=zeros(1,n);
verygoodNEnotlevk=zeros(1,n);

verygoodsymmNE=zeros(1,n);
verygoodsymmNElev1=zeros(1,n);
verygoodsymmNEnotlev1=zeros(1,n);
verygoodsymmNEnotlevk=zeros(1,n);
for i=1:n
    verygoodNE(i)=logical(sum(PartofGoodNE{i})>0);
    verygoodNElev1(i)=logical(sum(PartofGoodNELev1{i})>0);
    verygoodNEnotlev1(i)=logical(sum(PartofGoodNENotLev1{i})>0);
    verygoodNEnotlevk(i)=logical(sum(PartofGoodNENotLevk{i})>0);
    
    verygoodsymmNE(i)=logical(sum(PartofGoodSymmNE{i})>0);
    verygoodsymmNElev1(i)=logical(sum(PartofGoodSymmNELev1{i})>0);
    verygoodsymmNEnotlev1(i)=logical(sum(PartofGoodSymmNENotLev1{i})>0);
    verygoodsymmNEnotlevk(i)=logical(sum(PartofGoodSymmNENotLevk{i})>0);
end

verygoodsymmNEnotlev1_70=zeros(1,n);
verygoodsymmNEnotlev1_80=zeros(1,n);
for i=1:n
    verygoodsymmNEnotlev1_70(i)=logical(sum(PartofGoodSymmNENotLev1_70{i})>0);
    verygoodsymmNEnotlev1_80(i)=logical(sum(PartofGoodSymmNENotLev1_80{i})>0);
end


%% Action Score

actionscore=cell(n,1);
for i=1:n
    for j=1:3
       actionscore{i}=IndNE{i}+level1ans{i}+IndParetoNE{i}+maxmax{i}+level2{i}(1,:)'+level3{i}(1,:)'+level4{i}(1,:)'+level5{i}(1,:)'+level6{i}(1,:)'+level7{i}(1,:)'+Maxmin{i}{1}(j);
    end
end


%% Other Features

BestforBoth=zeros(n,1);
for i=1:n
    x=row{i}(:);
    y=column{i}(:);
    if x(find(maxpayoffs{i}))==max(x) & y(find(maxpayoffs{i}))==max(y)
        BestforBoth(i)=1;
    end
end


%% Game Features

gap=zeros(1,n);
for i=1:n
    obv=level1ans{i}+IndMaxPayoff{i}+maxmax{i};
    [~,I]=max(obv);
    Y=obv;
    Y(I)=[];
    gap(i)=max(obv)-max(Y);
end

diff=zeros(1,n);
for i=1:n
    Sum=sum(row{i},2);
    [~,I]=max(Sum);
    Y=Sum;
    Y(I)=[];
    diff(i)=max(Sum)-max(Y);
end

indDiff1=zeros(1,n);
indDiff15=zeros(1,n);
indDiff2=zeros(1,n);
indDiff25=zeros(1,n);
indDiff3=zeros(1,n);
indDiff35=zeros(1,n);
indDiff4=zeros(1,n);
indDiff45=zeros(1,n);
indDiff5=zeros(1,n);
for i=1:n
    maxrowpay=max(max(row{i}));
    maxcolpay=max(max(column{i}));
    maxpay=max(maxrowpay,maxcolpay);
    indDiff1(i)=double(logical(diff(i)>0.1*maxpay));
    indDiff15(i)=double(logical(diff(i)>0.15*maxpay));
    indDiff2(i)=double(logical(diff(i)>0.2*maxpay));
    indDiff25(i)=double(logical(diff(i)>0.25*maxpay));
    indDiff3(i)=double(logical(diff(i)>0.3*maxpay));
    indDiff35(i)=double(logical(diff(i)>0.35*maxpay));
    indDiff4(i)=double(logical(diff(i)>0.4*maxpay));
    indDiff45(i)=double(logical(diff(i)>0.45*maxpay));
    indDiff5(i)=double(logical(diff(i)>0.5*maxpay));
end

ind100=zeros(1,n);
num100=zeros(1,n);
lev1and2=zeros(1,n);
lev1andNE=zeros(1,n);
symmNash=zeros(1,n);
for i=1:n
    ind100(i)=double(logical(sum(sum(double(logical(row{i}==100))))>0));
    num100(i)=sum(sum(double(logical(row{i}==100))));
    lev1and2(i)=double(logical(sum(level1ans{i}.*level2{i}(1,:)'))>0);
    lev1andNE(i)=double(logical(sum(level1ans{i}.*IndNE{i})>0));
    symmNash(i)=double(logical(sum(diag(Nash{i}))>0));
end


%% Create Features
feat_act=cell(1,n);
for i=1:n
    for j=1:3
        feat_act{j}(i,:)=[IndNE{i}(j);
            IndMaxPayoff{i}(j);
            IndParetoNE{i}(j);
            IndParetoUndAct{i}(j);
            maxmax{i}(j);
            Maxmin{i}{1}(j);
            level1ans{i}(j);
            level2{i}(1,j);
            level3{i}(1,j);
            PartofGoodNE{i}(j);
            PartofGoodSymmNE{i}(j);
            actionscore{i}(j);
            ];
    end
end

feat_game=cell(1,n);
for i=1:n
    feat_game{i}=[
        sum(sum(Nash{i}));%Number of NE
        length(surviveround3{i}{1}{1}); %Number of rationalizable actions
        logical(length(surviveround1{i}{1}{1})<3); %At least one action is strictly dominated in round 1
        BestforBoth(i); %Existence of an action that maximizes both players payoffs
        sum(maxmax{i}); %Number of different rows with a "max" payoff
        sum(sum(maxpayoffs{i},2)); %Number of different rows with a "best-for-both" action profile
        sum(IndParetoNE{i}); %Is there a Pareto-dominant NE?
        sum(level1ans{i}); %Number of Level-1 Answers
        sum(level1ans{i}.*IndMaxPayoff{i}.*maxmax{i}); %Number of actions that are all
        max(level1ans{i}+IndMaxPayoff{i}+maxmax{i}); %Obviousness score
        3-length(surviveround1{i}{1}{1}); %Number of strictly dominated actions
        decoy1(i); %Does there exist a decoy?
        length(find(supportlevk(i,:))); %How many actions are level k for some k
        ind100(i); %Is there a row payoff that is 100?
        num100(i); %How many row payoffs are 100?
        lev1and2(i); %Is there a level 1 action that is also level 2?
        lev1andNE(i); %Is there a level 1 action that is also NE?
        symmNash(i); %Is there a symmetric Nash equilibrium
        verygoodNE(i); %Is there a NE that achieves 75% of max possible total payoffs?
        verygoodNElev1(i); %Is there a NE that achieves 75% of max possible payoffs and is also level 1?
        verygoodNEnotlev1(i); %Is there a NE that achieves 75% of max possible payoffs and is not level 1?
        verygoodNEnotlevk(i); %Is there a NE that achieves 75% of max possible payoffs and is not level k for any k?
        verygoodsymmNE(i); %Is there a symm NE that achieves 75% of max possible total payoffs?
        verygoodsymmNElev1(i); %Is there a symm NE that achieves 75% of max possible payoffs and is also level 1?
        verygoodsymmNEnotlev1(i); %Is there a symm NE that achieves 75% of max possible payoffs and is not level 1?
        verygoodsymmNEnotlevk(i); %Is there a symm NE that achieves 75% of max possible payoffs and is not level k for any k?
        double(logical(sum(level1ans{i}.*IndMaxPayoff{i}))>0); %Is there a level 1 action that maximizes the sum of payoffs?
        double(logical(sum(level1ans{i}.*maxmax{i}))>0); %Is there a level 1 action that is also max-max?
        double(logical(sum(level1ans{i}.*IndParetoNE{i}))>0) %Is there a level 1 action that is also part of a Pareto-dominant NE?
        decoy2(i); %Does there exist a decoy, v2
        decoy3(i); %Does there exist a decoy, v3     
        indDiff25(i); %Indicator: diff exceeds 0.25*max payoff
        verygoodsymmNEnotlev1_70(i); %Is there a symm NE that achieves 70% of max possible payoffs and is not level 1?
        verygoodsymmNEnotlev1_80(i) %Is there a symm NE that achieves 80% of max possible payoffs and is not level 1?
        ];
end

for i=1:n
    FeaturesMatrix(i,:)=transpose(feat_game{i});
    FeaturesAct(i,:)=horzcat(feat_act{1}(i,:),feat_act{2}(i,:),feat_act{3}(i,:));
end


%% Descriptions of Features

Description_a1={
    'a1 is part of a NE'
    'a1 is part of an action profile that maximizes the sum of player payoffs'
    'a1 is part of a Pareto dominant NE'
    'a1 is part of an action profile that is Pareto undominated'
    'a1 is max-max'
    'a1 is max-min'
    'a1 is level 1'
    'a1 is level 2'
    'a1 is level 3'
    'a1 is part of a good NE'
    'a1 is part of a good symmetric NE'
    'a1 score'
    };

Description_a2={
    'a2 is part of a NE'
    'a2 is part of an action profile that maximizes the sum of player payoffs'
    'a2 is part of a Pareto dominant NE'
    'a2 is part of an action profile that is Pareto undominated'
    'a2 is max-max'
    'a2 is max-min'
    'a2 is level 1'
    'a2 is level 2'
    'a2 is level 3'
    'a2 is part of a good NE'
    'a2 is part of a good symmetric NE'
    'a2 score'
    };

Description_a3={
    'a3 is part of a NE'
    'a3 is part of an action profile that maximizes the sum of player payoffs'
    'a3 is part of a Pareto dominant NE'
    'a3 is part of an action profile that is Pareto undominated'
    'a3 is max-max'
    'a3 is max-min'
    'a3 is level 1'
    'a3 is level 2'
    'a3 is level 3'
    'a3 is part of a good NE'
    'a3 is part of a good symmetric NE'
    'a3 score'
    };

DescriptionAct=[Description_a1; Description_a2; Description_a3];

DescriptionMatrix={
        'Number of NE'
        'Number of rationalizable actions'
        'At least one action is strictly dominated in round 1'
        'Existence of an action that maximizes both players payoffs'
        'Number of different rows with a "max" payoff'
        'Number of different rows with a "best-for-both" action profile'
        'Is there a Pareto-dominant NE?'
        'Number of Level-1 Answers'
        'Number of actions that are lev-1, max-max, and best-for-both'
        'Obviousness score'
        'Number of strictly dominated actions'
        'Does there exist a decoy?'
        'How many actions are level k for some k'
        'Is there a row payoff that is 100?'
        'How many row payoffs are 100?'
        'Is there a level 1 action that is also level 2?'
        'Is there a level 1 action that is also NE?'
        'Is there a symmetric Nash equilibrium'
        'Is there a NE that achieves 75% of max possible total payoffs?'
        'Is there a NE that achieves 75% of max possible payoffs and is also level 1?'
        'Is there a NE that achieves 75% of max possible payoffs and is not level 1?'
        'Is there a NE that achieves 75% of max possible payoffs and is not level k for any k?'
        'Is there a symm NE that achieves 75% of max possible total payoffs?'
        'Is there a symm NE that achieves 75% of max possible payoffs and is also level 1?'
        'Is there a symm NE that achieves 75% of max possible payoffs and is not level 1?'
        'Is there a symm NE that achieves 75% of max possible payoffs and is not level k for any k?'
        'Is there a level 1 action that maximizes the sum of payoffs?'
        'Is there a level 1 action that is also max-max?'
        'Is there a level 1 action that is also part of a Pareto-dominant NE?'
        'Does there exist a decoy, v2'
        'Does there exist a decoy, v3'    
        'Indicator: diff exceeds 0.25*max payoff'
        'Is there a symm NE that achieves 70% of max possible payoffs and is not level 1?'
        'Is there a symm NE that achieves 80% of max possible payoffs and is not level 1?'
  };


allvars={FeaturesAct,DescriptionAct,FeaturesMatrix,DescriptionMatrix,IndNE};